﻿using System;
using System.Windows.Forms;
using System.Drawing;

namespace XRE.NodeControls
{
	internal class StringControl : NodeControl
	{
		internal StringControl(Control parent, XRENode xreNode) : base(parent, xreNode)
		{
			TextBox textBox = new TextBox();
			textBox.Bounds = new Rectangle(LabelEnd, 5, DefaultControlWidth, 1);
			textBox.Text = (xreNode.Values[0] ?? "").ToString();
			textBox.TextChanged += textBox_TextChanged;

			BasePanel.Controls.Add(textBox);
			AssignToolTipTo(textBox);
        }

		private void textBox_TextChanged(object sender, EventArgs e)
		{
			XreNode.Values[0] = ((TextBox)sender).Text;
		}
	}
}
