﻿using System;
using System.Collections.Generic;

namespace XRE
{
	internal class XRENode
	{
		#region Constructors

		/// <summary>
		/// For sections
		/// </summary>
		internal XRENode(string name, NodeType type)
		{
			this.name = name;
			this.type = type;
			nodes = new List<XRENode>();
		}

		/// <summary>
		/// For items
		/// </summary>
		internal XRENode(string entry, NodeType type, string name, List<object> values,
			string imageName, string hint, string width, string options, string unit,
            string minimum, string maximum, string increment, string decimalPlaces, string multiplier)
		{
			this.entry = entry;
			this.type = type;
			this.name = name;
			this.values = values;

			this.imageName = imageName;
			this.hint = hint;
			this.width = width;
			this.options = options;
			this.unit = unit;

			this.minimum = minimum;
			this.maximum = maximum;
			this.increment = increment;
			this.decimalPlaces = decimalPlaces;
			this.multiplier = multiplier;

			nodes = new List<XRENode>();
		}

		#endregion

		#region Public methods

		/// <summary>
		/// Get the node type from a string.
		/// </summary>
		internal static NodeType GetNodeType(string str)
		{
			str = str.ToLower().Trim();
			switch(str) {

				// Scalar types

				case "int":
				case "integer":
					return NodeType.Integer;
				case "uint":
				case "dword":
					return NodeType.UInt;
				case "long":
					return NodeType.Long;
				case "ulong":
				case "qword":
					return NodeType.ULong;
				case "float":
				case "double":
					return NodeType.Float;

				// Other types

				case "bool":
				case "boolean":
					return NodeType.Boolean;
				case "string":
					return NodeType.String;
				case "color":
				case "colour":
					return NodeType.Color;
				case "lov":
					return NodeType.LOV;

				default:
					return NodeType.None;
			}
		}

		#endregion

		#region Public enumerations

		internal enum NodeType
		{
			None,

			// Section type
			Section,

			// Scalar types
			Integer,
			UInt,
			Long,
			ULong,
			Float,

			// Other types
			Boolean,
			String,
			Color,
			LOV
		}

		#endregion

		#region Properties

		internal List<XRENode> Nodes
		{
			get
			{
				return nodes;
			}
		}

		internal NodeType Type
		{
			get
			{
				return type;
			}
		}

		internal string Name
		{
			get
			{
				return name;
			}
		}

		internal List<object> Values
		{
			get
			{
				return values;
			}
			set
			{
				values = value;
			}
		}

		internal string ImageName
		{
			get
			{
				return imageName;
			}
		}

		internal string Hint
		{
			get
			{
				return hint;
			}

			//set
			//{
			//	hint = value;
			//}
		}

		internal string Width
		{
			get
			{
				return width;
			}
		}

		internal string Options
		{
			get
			{
				return options;
			}
		}

		internal string Unit
		{
			get
			{
				return unit;
			}
		}

		internal string Minimum
		{
			get
			{
				return minimum;
			}
		}

		internal string Maximum
		{
			get
			{
				return maximum;
			}
		}

		internal string Increment
		{
			get
			{
				return increment;
			}
		}

		internal string DecimalPlaces
		{
			get
			{
				return decimalPlaces;
			}
		}

		internal string Multiplier
		{
			get
			{
				return multiplier;
			}
		}

		internal string Entry
		{
			get
			{
				return entry;
			}
		}

		#endregion

		#region Private fields

		private string entry;
		private NodeType type;
		private string name;
		private string imageName, hint, width, options, unit;
		private string minimum, maximum, increment, decimalPlaces, multiplier;

		private List<XRENode> nodes;
		private List<object> values;

		#endregion
	}
}
