﻿using System;
using System.IO;
using System.Runtime.InteropServices;
using System.Threading;
using System.Windows.Forms;

namespace XRE.Utils
{
	public static class Debugging
	{
		public static void SetConsole(int xpos, int ypos, int width, int height)
		{
			AllocConsole();
			IntPtr console = GetConsoleWindow();
			SetWindowPos(console, 0, xpos, ypos, width, height);
        }

		public static void GenericExceptionHandler(object sender, ThreadExceptionEventArgs e)
		{
			string errorMsg = e.Exception.Message + Environment.NewLine + e.Exception.StackTrace + Environment.NewLine;

#if true
			Console.Write(errorMsg);
#else
			using(StreamWriter sw = new StreamWriter(Application.ExecutablePath.Replace("exe", "log"), true)) {
				sw.WriteLine("{0} {1} ==> {2}",
				DateTime.Now.ToShortDateString().ToString(),
				DateTime.Now.ToLongTimeString().ToString(),
				errorMsg
				);
				sw.Flush();
			}
#endif
		}

		public static void ShowError(string msg)
		{
			MessageBox.Show(msg, "Error", MessageBoxButtons.OK, MessageBoxIcon.Warning);
		}

		#region Windows native code

		[DllImport("user32.dll")]
		private static extern IntPtr SetWindowPos(IntPtr hWnd, int hWndInsertAfter, int x, int Y, int cx, int cy, int wFlags = 0);

		[DllImport("kernel32.dll", SetLastError = true)]
		private static extern IntPtr GetConsoleWindow();

		[DllImport("kernel32.dll")]
		private static extern bool AllocConsole();

		private const int SWP_NOSIZE = 0x0001;

		#endregion
	}
}
