﻿using System;
using System.Windows.Forms;
using System.Drawing;

using XRE.Utils;

namespace XRE.NodeControls
{
	internal class LOVControl : NodeControl
	{
		internal LOVControl(Control parent, XRENode xreNode) : base(parent, xreNode)
		{
			ComboBox cbLov = new ComboBox();
			cbLov.DropDownStyle = ComboBoxStyle.DropDownList;
			cbLov.Bounds = new Rectangle(LabelEnd, 5, DefaultControlWidth, 10);
			if(xreNode.Options != null) {
				cbLov.Items.AddRange(xreNode.Options.Split(','));
			}
			cbLov.SelectedIndex = (xreNode.Values[0] ?? 0).ToString().ToInt();

			cbLov.SelectedIndexChanged += cbLov_SelectedIndexChanged;

			BasePanel.Controls.Add(cbLov);
			AssignToolTipTo(cbLov);
		}

		private void cbLov_SelectedIndexChanged(object sender, EventArgs e)
		{
			XreNode.Values[0] = ((ComboBox)sender).SelectedIndex;
		}
	}
}
