﻿using System;
using System.IO;
using System.Text;

namespace XRE.Utils
{
	public class TextStreamWriter : StringWriter
	{
		public TextStreamWriter()
		{
			sbOutput = new StringBuilder();
			mStream = new MemoryStream(1000000);
			writer = new StreamWriter(mStream);
			writer.AutoFlush = true;
		}

		public override void Write(char value)
		{
			base.Write(value);
            sbOutput.Append(value.ToString());
			writer.Write(value);
		}

		public override void Write(string value)
		{
			base.Write(value);
			sbOutput.Append(value.ToString());
			writer.Write(value);
		}

		public override void WriteLine(string value)
		{
			base.WriteLine(DateTime.Now.ToString(value));
			sbOutput.AppendLine(value.ToString());
			writer.Write(value);
		}

		public string Text
		{
			get
			{
				return sbOutput.ToString();
			}
		}

		#region Fields

		private StringBuilder sbOutput;

		protected StreamWriter writer;
		protected MemoryStream mStream;

		#endregion
	}
}
