﻿using System;
using System.Xml.Linq;

namespace XRE.Utils
{
	/// <summary>
	/// Safe extension methods for XML
	/// </summary>
	public static class XMLExtensions
	{
		/// <summary>
		/// Retrieve the string value of a child element. Nonexistent child elements return a default value.
		/// </summary>
		/// <param name="xElement">The parent XML element.</param>
		/// <param name="name">The name of the child element to get.</param>
		/// <param name="defaultValue">The default string value.</param>
		/// <returns>The string value.</returns>
		public static string GetElementValue(this XElement xElement, XName name, string defaultValue = "")
		{
			XElement xElem = xElement.Element(name);
            return xElem == null ? defaultValue : xElem.Value;
		}

		/// <summary>
		/// Retrieve the string value of an attribute. Nonexistent attributes return a default value.
		/// </summary>
		/// <param name="xElement">The XML element to retrieve the attribute from.</param>
		/// <param name="name">The name of the attribute to get.</param>
		/// <param name="defaultValue">The default string value.</param>
		/// <returns>The string value.</returns>
		public static string GetAttributeValue(this XElement xElement, XName name, string defaultValue = "")
		{
			XAttribute xAttr = xElement.Attribute(name);
			return xAttr == null ? defaultValue : xAttr.Value;
		}
	}
}
