﻿using System;
using System.Windows.Forms;
using System.Drawing;

using XRE.Utils;

namespace XRE.NodeControls
{
	internal class NumericControl : NodeControl
	{
		internal NumericControl(Control parent, XRENode xreNode) : base(parent, xreNode)
		{
			NumericUpDown numericUpDown = new NumericUpDown();
			numericUpDown.Bounds = new Rectangle(LabelEnd, 5, 10, 10);

			bool minIsNull = xreNode.Minimum == "null";
			bool maxIsNull = xreNode.Maximum == "null";
			multiplier = xreNode.Multiplier.ToDecimal(1);
			string val = (xreNode.Values[0] ?? 0).ToString();

            switch(xreNode.Type) {
				case XRENode.NodeType.Integer:
					numericUpDown.Minimum = minIsNull ? int.MinValue : xreNode.Minimum.ToInt();
					numericUpDown.Maximum = maxIsNull ? int.MaxValue : xreNode.Maximum.ToInt();
					numericUpDown.Increment = xreNode.Increment.ToInt();
					numericUpDown.Value = val.ToInt().Clamp((int)numericUpDown.Minimum, (int)numericUpDown.Maximum) * multiplier;
					numericUpDown.Width = xreNode.Width.ToInt(defaultNumWidth).Clamp(minWidth, DefaultControlWidth);
					break;
				case XRENode.NodeType.UInt:
					numericUpDown.Minimum = minIsNull ? uint.MinValue : xreNode.Minimum.ToUInt();
					numericUpDown.Maximum = maxIsNull ? uint.MaxValue : xreNode.Maximum.ToUInt();
					numericUpDown.Increment = xreNode.Increment.ToUInt();
					numericUpDown.Value = val.ToUInt().Clamp((uint)numericUpDown.Minimum, (uint)numericUpDown.Maximum) * multiplier;
					numericUpDown.Width = xreNode.Width.ToInt(defaultNumWidth).Clamp(minWidth, DefaultControlWidth);
					break;
				case XRENode.NodeType.Long:
					numericUpDown.Minimum = minIsNull ? long.MinValue : xreNode.Minimum.ToLong();
					numericUpDown.Maximum = maxIsNull ? long.MaxValue : xreNode.Maximum.ToLong();
					numericUpDown.Increment = xreNode.Increment.ToLong();
					numericUpDown.Value = val.ToLong().Clamp((long)numericUpDown.Minimum, (long)numericUpDown.Maximum) * multiplier;
					numericUpDown.Width = xreNode.Width.ToInt(DefaultControlWidth).Clamp(minWidth, DefaultControlWidth);
					break;
				case XRENode.NodeType.ULong:
					numericUpDown.Minimum = minIsNull ? ulong.MinValue : xreNode.Minimum.ToULong();
					numericUpDown.Maximum = maxIsNull ? ulong.MaxValue : xreNode.Maximum.ToULong();
					numericUpDown.Increment = xreNode.Increment.ToULong();
					numericUpDown.Value = val.ToULong().Clamp((ulong)numericUpDown.Minimum, (ulong)numericUpDown.Maximum) * multiplier;
					numericUpDown.Width = xreNode.Width.ToInt(DefaultControlWidth).Clamp(minWidth, DefaultControlWidth);
					break;
				case XRENode.NodeType.Float:
					numericUpDown.Minimum = minIsNull ? decimal.MinValue : xreNode.Minimum.ToDecimal();
					numericUpDown.Maximum = maxIsNull ? decimal.MaxValue : xreNode.Maximum.ToDecimal();
					numericUpDown.Increment = xreNode.Increment.ToDecimal();
					numericUpDown.Value = val.ToDecimal().Clamp(numericUpDown.Minimum, numericUpDown.Maximum) * multiplier;
					numericUpDown.DecimalPlaces = xreNode.DecimalPlaces.ToInt();
					numericUpDown.ThousandsSeparator = true;
					numericUpDown.Width = xreNode.Width.ToInt(defaultNumWidth).Clamp(minWidth, DefaultControlWidth);
					break;
			}

			xreNode.Values[0] = numericUpDown.Value / multiplier;
			numericUpDown.ValueChanged += numericUpDown_ValueChanged;

			BasePanel.Controls.Add(numericUpDown);
			AssignToolTipTo(numericUpDown);

			// Unit label

			if(!string.IsNullOrWhiteSpace(xreNode.Unit)) {
				Label unitLabel = new Label();
				unitLabel.Location = new Point(numericUpDown.Right + 5, 9);
				unitLabel.Text = xreNode.Unit;
				unitLabel.BackColor = Color.Transparent;
				AssignToolTipTo(unitLabel);
				BasePanel.Controls.Add(unitLabel);
			}

		}

		private void numericUpDown_ValueChanged(object sender, EventArgs e)
		{
			XreNode.Values[0] = ((NumericUpDown)sender).Value / multiplier;
		}

		private decimal multiplier = 1;
		private const int defaultNumWidth = 50;
		private const int minWidth = 40;

	}
}
