﻿using System;
using System.Windows.Forms;
using System.Drawing;

using XRE.Utils;

namespace XRE.NodeControls
{
	internal class BooleanControl : NodeControl
	{
		internal BooleanControl(Control parent, XRENode xreNode) : base(parent, xreNode)
		{
			CheckBox checkBox = new CheckBox();
			checkBox.AutoSize = true;
			checkBox.Location = new Point(LabelEnd, 10);
			bool value = (xreNode.Values[0] ?? false).ToString().ToBoolean();
            checkBox.Checked = xreNode.Options.ToLower() == "invert" ? !value : value;

			checkBox.CheckedChanged += checkBox_CheckedChanged;

			BasePanel.Controls.Add(checkBox);
			AssignToolTipTo(checkBox);
		}

		private void checkBox_CheckedChanged(object sender, EventArgs e)
		{
			XreNode.Values[0] = ((CheckBox)sender).Checked ? true : false;
		}
	}
}
