﻿using System;
using System.Windows.Forms;
using System.Drawing;

using XRE.Utils;

namespace XRE.NodeControls
{
	internal class ColorControl : NodeControl
	{
		#region Constructor

		internal ColorControl(Control parent, XRENode xreNode) : base(parent, xreNode)
		{
			// Color swatch

			Label colorSwatch = new Label();
			colorSwatch.Bounds = new Rectangle(LabelEnd, 4, 40, 25);
			// Always remove transparency for UI display
			colorSwatch.BackColor = Color.FromArgb(0xFF, getColorValue());
			colorSwatch.Click += new EventHandler(colorSwatchClick);

			BasePanel.Controls.Add(colorSwatch);
			AssignToolTipTo(colorSwatch);

			// Thin border

			Label border = new Label();
			border.Bounds = new Rectangle(LabelEnd - 1, 3, 42, 27);
			border.BackColor = Color.White;
			BasePanel.Controls.Add(border);
			AssignToolTipTo(border);

			// Label

			label = new Label();
			label.Bounds = new Rectangle(colorSwatch.Right + 10, 10, 60, 20);
			label.Font = new Font("Consolas", 9);
			setLabelText(colorSwatch.BackColor.ToArgb());
			BasePanel.Controls.Add(label);
			AssignToolTipTo(label);
		}

		#endregion

		#region Private methods

		private void colorSwatchClick(object sender, EventArgs e)
		{
			ColorDialog cd = new ColorDialog();

			cd.FullOpen = true;
			cd.Color = ((Control)sender).BackColor;

			if(cd.ShowDialog() == DialogResult.OK) {

				int color;

				((Control)sender).BackColor = cd.Color;
				if(XreNode.Options.ToLower() == "bgr") {
					Color rgbColor = Color.FromArgb(0xFF, cd.Color);
					color = Color.FromArgb(0xFF, rgbColor.B, rgbColor.G, rgbColor.R).ToArgb();
				} else {
					color = cd.Color.ToArgb();
				}

				setColorValue(Color.FromArgb(color));
				setLabelText(color);
			}
		}

		private Color getColorValue()
		{
			// Color may be described by 1 to 4 separate registry entries

			Color color;

			switch(XreNode.Values.Count) {

				case 1:
					if(XreNode.Options.ToLower() == "bgr") {
						Color bgrColor = (XreNode.Values[0] ?? 0).ToString().ToColor();
						color = Color.FromArgb(bgrColor.A, bgrColor.B, bgrColor.G, bgrColor.R);
					} else {
						color = (XreNode.Values[0] ?? 0).ToString().ToColor();
					}
					break;

				case 2:
					color = Color.FromArgb(
						(XreNode.Values[0] ?? 0xFF).ToString().ToInt(),
						(XreNode.Values[1] ?? 0).ToString().ToColor());
					break;

				case 3:
					color = Color.FromArgb(
						0xFF,       // Opaque
						(XreNode.Values[0] ?? 0).ToString().ToInt(),
						(XreNode.Values[1] ?? 0).ToString().ToInt(),
						(XreNode.Values[2] ?? 0).ToString().ToInt());
					break;

				case 4:
					color = Color.FromArgb(
						(XreNode.Values[0] ?? 0xFF).ToString().ToInt(),
						(XreNode.Values[1] ?? 0).ToString().ToInt(),
						(XreNode.Values[2] ?? 0).ToString().ToInt(),
						(XreNode.Values[3] ?? 0).ToString().ToInt());
					break;

				default:
					throw new Exception();
			}

			//setValue(color);

			return color;// Color.FromArgb(0xFF, color);
		}

		private void setColorValue(Color color)
		{
			string[] entries = XreNode.Entry.Split(',');

			switch(entries.Length) {

				case 1:
					if(XreNode.Options.ToLower() == "bgr") {
						XreNode.Values[0] = Color.FromArgb(color.A, color.B, color.G, color.R);
					} else {
						XreNode.Values[0] = color.ToArgb();
					}
					break;

				case 2:
					XreNode.Values[0] = color.A;
					XreNode.Values[1] = color.ToArgb() & 0xFFFFFF;
					break;

				case 3:
					XreNode.Values[0] = color.R;
					XreNode.Values[1] = color.G;
					XreNode.Values[2] = color.B;
					break;

				case 4:
					XreNode.Values[0] = color.A;
					XreNode.Values[1] = color.R;
					XreNode.Values[2] = color.G;
					XreNode.Values[3] = color.B;
					break;

				default:
					throw new Exception();
			}
		}

		private void setLabelText(int color)
		{
			label.Text = "#" + (color & 0xFFFFFF).ToHex();
		}

		#endregion

		#region Private fields

		private Label label;

		#endregion
	}
}
