﻿using System;
using System.Runtime.InteropServices;

namespace XRE.Utils
{
	public static class DebugConsole
	{
		public static void SetConsole(int xpos, int ypos, int width, int height)
		{
			AllocConsole();
			IntPtr console = GetConsoleWindow();
			SetWindowPos(console, 0, xpos, ypos, 0, 0, SWP_NOSIZE);
			Console.SetWindowSize(width, height);
        }

		[DllImport("user32.dll")]
		private static extern IntPtr SetWindowPos(IntPtr hWnd, int hWndInsertAfter, int x, int Y, int cx, int cy, int wFlags);

		[DllImport("kernel32.dll", SetLastError = true)]
		private static extern IntPtr GetConsoleWindow();

		[DllImport("kernel32.dll")]
		private static extern bool AllocConsole();

		private const int SWP_NOSIZE = 0x0001;
	}
}
