﻿using System;
using System.Windows.Forms;

namespace XRE
{
	public partial class LogForm : Form
	{
		public LogForm(string logText)
		{
			InitializeComponent();
			this.Font = SystemInformation.MenuFont;

			log = logText;
		}

		private void LogForm_Load(object sender, EventArgs e)
		{
			txtLog.Text = log;
			txtLog.SelectionStart = 0;
		}

		private string log;

		private void btnCopy_Click(object sender, EventArgs e)
		{
			Clipboard.SetText(log);
			MessageBox.Show("The text was copied to the clipboard.", "Information", MessageBoxButtons.OK, MessageBoxIcon.Information);
		}
	}
}
